#pragma once

#include "GamebaseInternalResult.h"

struct FGamebaseAuthEpicLoginData
{
    FString AccessToken;
};

struct FGamebaseAuthEpicLogoutData
{
};

using FGamebaseAuthEpicLoginResult = FGamebaseInternalResult<FGamebaseAuthEpicLoginData>;
using FGamebaseAuthEpicLogoutResult = FGamebaseInternalResult<FGamebaseAuthEpicLogoutData>;

class IGamebaseEOSAuthHandler
{
public:
    using FLoginFunc = TUniqueFunction<void(const FGamebaseAuthEpicLoginResult&)>;
    
    virtual ~IGamebaseEOSAuthHandler() = default;
    
    virtual void Login(FLoginFunc&& Callback) = 0;
    virtual void Logout() = 0;
    virtual bool IsLoggedIn() const = 0;
};