#pragma once

#include "CoreMinimal.h"
#include "Subsystems/GameInstanceSubsystem.h"
#include "GamebaseSharedEOS.generated.h"

#ifdef WITH_EOS_SDK
#include "eos_types.h"
using FEOSPlatformHandle = EOS_HPlatform;
#else
using FEOSPlatformHandle = void*;
#endif

class IGamebaseEOSAuthHandler;
class IGamebaseEOSInitializer;

UCLASS()
class GAMEBASESHAREDEOS_API UGamebaseSharedEOS
    : public UGameInstanceSubsystem
{
    GENERATED_BODY()

public:
    using FAuthHandlerPtr = TSharedPtr<IGamebaseEOSAuthHandler>;
    using FPlatformPtr = TSharedPtr<IGamebaseEOSInitializer>;
    
    FAuthHandlerPtr GetAuthHandler() const;

    void SetPlatformHandle(FEOSPlatformHandle PlatformHandle);
    FEOSPlatformHandle GetPlatformHandle() const;

private:
    // USubsystem interface
    virtual void Initialize(FSubsystemCollectionBase& Collection) override;
    virtual void Deinitialize() override;
    virtual bool ShouldCreateSubsystem(UObject* Outer) const override;
    // ~USubsystem interface

private:
    FPlatformPtr Platform;
    FAuthHandlerPtr AuthHandler;
};