#include "GamebaseEOSInitializerFactory.h"

#include "GamebaseDebugLogger.h"
#include "IGamebaseEOSInitializer.h"

#if WITH_GAMEBASE_EOS_NATIVE_SDK
#include "EOSSDK/GamebaseEOSNativeInitializer.h"
#endif

#if WITH_GAMEBASE_EOS_OSS
#include "OnlineSubsystem/GamebaseEOSOSSInitializer.h"
#endif

namespace GamebaseEOSInitializerFactory
{
    TSharedPtr<IGamebaseEOSInitializer> CreateInitializer()
    {
#if WITH_GAMEBASE_EOS_OSS
        auto OSSInitializer = MakeShared<FGamebaseEOSOSSInitializer>();
        if (OSSInitializer->IsAvailable())
        {
            GAMEBASE_LOG_GLOBAL_DEBUG("Using OnlineSubsystem initializer");
            return OSSInitializer;
        }
#endif

#if WITH_GAMEBASE_EOS_NATIVE_SDK
        auto NativeInitializer = MakeShared<FGamebaseEOSNativeInitializer>();
        if (NativeInitializer->IsAvailable())
        {
            GAMEBASE_LOG_GLOBAL_DEBUG("Using Native initializer");
            return NativeInitializer;
        }
#endif

        GAMEBASE_LOG_GLOBAL_WARNING("No initializer available");
        return nullptr;
    }
    
    bool IsAvailable()
    {
#if WITH_GAMEBASE_EOS_SHARED
        return true;
#else
        return false;
#endif
    }
}
