#pragma once

#include "CoreMinimal.h"
#include "../IGamebaseEOSInitializer.h"

class FGamebaseEOSNativeInitializer final
    : public IGamebaseEOSInitializer
{
public:
    FGamebaseEOSNativeInitializer() = default;
    virtual ~FGamebaseEOSNativeInitializer() override = default;

    virtual bool IsAvailable() const override;
    virtual void Initialize(UGameInstance* GameInstance) override;
    virtual void Deinitialize() override;
    virtual void SetPlatformHandle(FEOSPlatformHandle PlatformHandle) override;
    virtual FEOSPlatformHandle GetPlatformHandle() const override;

private:
#if WITH_GAMEBASE_EOS_SHARED
    FEOSPlatformHandle EOSPlatformHandle = nullptr;
#endif
};
