#include "GamebaseEOSNativeInitializer.h"
#include "GamebaseDebugLogger.h"
#include "Engine/GameInstance.h"

bool FGamebaseEOSNativeInitializer::IsAvailable() const
{
#if WITH_GAMEBASE_EOS_SHARED && !WITH_GAMEBASE_EOS_OSS
    return true;
#else
    return false;
#endif
}

void FGamebaseEOSNativeInitializer::Initialize(UGameInstance* GameInstance)
{
    if (!GameInstance)
    {
        GAMEBASE_LOG_GLOBAL_ERROR("GameInstance is null");
        return;
    }

    GAMEBASE_LOG_GLOBAL_DEBUG("EOS Native initializer initialized");
}

void FGamebaseEOSNativeInitializer::Deinitialize()
{
#if WITH_GAMEBASE_EOS_SHARED
    EOSPlatformHandle = nullptr;
#endif
    GAMEBASE_LOG_GLOBAL_DEBUG("EOS Native initializer deinitialized");
}

void FGamebaseEOSNativeInitializer::SetPlatformHandle(const FEOSPlatformHandle PlatformHandle)
{
#if WITH_GAMEBASE_EOS_SHARED
    if (PlatformHandle)
    {
        EOSPlatformHandle = PlatformHandle;
        GAMEBASE_LOG_GLOBAL_DEBUG("EOS Platform Handle set successfully (Native initializer)");
    }
    else
    {
        GAMEBASE_LOG_GLOBAL_ERROR("SetPlatformHandle EOS_HPlatform is null");
    }
#else
    GAMEBASE_LOG_GLOBAL_WARNING("SetPlatformHandle called but EOS Native is not available");
#endif
}

FEOSPlatformHandle FGamebaseEOSNativeInitializer::GetPlatformHandle() const
{
#if WITH_GAMEBASE_EOS_SHARED
    return EOSPlatformHandle;
#else
    return nullptr;
#endif
}
