#include "GamebaseSharedEOS.h"
#include "GamebaseDebugLogger.h"
#include "Auth/GamebaseSharedEOSDefines.h"
#include "Initializer/GamebaseEOSInitializerFactory.h"
#include "Initializer/IGamebaseEOSInitializer.h"

UGamebaseSharedEOS::FAuthHandlerPtr UGamebaseSharedEOS::GetAuthHandler() const
{
    return AuthHandler;
}

void UGamebaseSharedEOS::SetPlatformHandle(const FEOSPlatformHandle PlatformHandle)
{
    if (Platform)
    {
        Platform->SetPlatformHandle(PlatformHandle);
    }
    else
    {
        GAMEBASE_LOG_GLOBAL_ERROR("Platform is not available for SetPlatformHandle");
    }
}

FEOSPlatformHandle UGamebaseSharedEOS::GetPlatformHandle() const
{
    if (Platform)
    {
        return Platform->GetPlatformHandle();
    }
    
    GAMEBASE_LOG_GLOBAL_ERROR("Platform is not available for GetPlatformHandle");
    return nullptr;
}

void UGamebaseSharedEOS::Initialize(FSubsystemCollectionBase& Collection)
{
    Super::Initialize(Collection);
    
    Platform = GamebaseEOSInitializerFactory::CreateInitializer();
    if (Platform)
    {
        Platform->Initialize(GetGameInstance());
    }
    
    AuthHandler = MakeShared<FGamebaseSDKAuthHandler>(GetGameInstance());
}

void UGamebaseSharedEOS::Deinitialize()
{
    Super::Deinitialize();

    if (AuthHandler.IsValid())
    {
        AuthHandler.Reset();
    }
    
    if (Platform)
    {
        Platform->Deinitialize();
        Platform.Reset();
    }
}

bool UGamebaseSharedEOS::ShouldCreateSubsystem(UObject* Outer) const
{
    return GamebaseEOSInitializerFactory::IsAvailable();
}