#pragma once

namespace GamebaseSharedEOS
{
    namespace Auth
    {
        const FName Domain { TEXT("GamebaseSharedEOS::Auth") };
    }
    
    namespace LoginType
    {
        const FString ExchangeCode(TEXT("exchangecode"));
        const FString Developer(TEXT("developer"));
        const FString AccountPortal(TEXT("accountportal"));
        const FString PersistentAuth(TEXT("persistentauth"));
    }

    const FString LastLoginType { TEXT("lastLoginType") };
    
    const FName Domain { TEXT("GamebaseAuthEpic") };
    
    const FName AuthorizationProtocol("epicgames");
}

#if WITH_GAMEBASE_EOS_OSS

#include "OnlineSubsystem/GamebaseOnlineSubsystemAuthHandler.h"

using FGamebaseSDKAuthHandler = FGamebaseOnlineSubsystemAuthHandler;

#elif WITH_GAMEBASE_EOS_NATIVE_SDK

#include "EOSSDK/GamebaseEOSSDKAuthHandler.h"

using FGamebaseSDKAuthHandler = FGamebaseEOSSDKAuthHandler;

#else

#include "IGamebaseEOSAuthHandler.h"

class FGamebaseSDKAuthHandler final
    : public IGamebaseEOSAuthHandler
{
public:
    explicit FGamebaseSDKAuthHandler(const TWeakObjectPtr<UGameInstance>& GameInstance) {}
    virtual void Login(FLoginFunc&& Callback) override { }
    virtual void Logout() override {}
    virtual bool IsLoggedIn() const override { return false; }
};

#endif
