#pragma once

#include "IGamebaseEOSAuthHandler.h"

class FGamebaseEOSAuthHandler
    : public IGamebaseEOSAuthHandler
{
public:
    virtual void Login(FLoginFunc&& Callback) override final;
    virtual void Logout() override final;
    virtual bool IsLoggedIn() const override final;
    
protected:
    using FLoginResultFuture = TFuture<FGamebaseAuthEpicLoginResult>;
    using FLoginResultPromise = TPromise<FGamebaseAuthEpicLoginResult>;
    using FLoginAsyncFunc = TFunction<FLoginResultFuture()>;
    
    using FLogoutResultFuture = TFuture<FGamebaseAuthEpicLogoutResult>;
    using FLogoutResultPromise = TPromise<FGamebaseAuthEpicLogoutResult>;
    using FLogoutAsyncFunc = TFunction<FLogoutResultFuture()>;
    
    virtual FLoginAsyncFunc AsyncLoginWithExistingSession() = 0;
    virtual FLoginAsyncFunc AsyncLoginWithExchangeCode() = 0;
    virtual FLoginAsyncFunc AsyncLoginWithPersistentAuth() = 0;
    virtual FLoginAsyncFunc AsyncLoginWithAccountPortal() = 0;

    virtual FLogoutAsyncFunc AsyncLogout() = 0;
};
