#pragma once

#include "Utils/GpLoggerJsonMacros.h"

struct FGpLoggerSettings final : FGpLoggerJsonSerializable
{
    struct FResult final : FGpLoggerJsonSerializable
    {
        struct FLog final : FGpLoggerJsonSerializable
        {
            bool bEnabled = true;
            
            BEGIN_GPLOGGER_JSON_SERIALIZER
                GPLOGGER_JSON_SERIALIZE("enable", bEnabled);
            END_GPLOGGER_JSON_SERIALIZER
        };
        
        struct FNetworkInsights final : FGpLoggerJsonSerializable
        {
            bool bEnabled = false;
            TArray<FString> Urls;
            
            BEGIN_GPLOGGER_JSON_SERIALIZER
                GPLOGGER_JSON_SERIALIZE("enable", bEnabled);
                GPLOGGER_JSON_SERIALIZE_ARRAY("urls", Urls);
            END_GPLOGGER_JSON_SERIALIZER
        };

        struct FFilter final : FGpLoggerJsonSerializable
        {
            struct FLogLevelFilter final : FGpLoggerJsonSerializable
            {
                bool bEnabled = false;
                FString LogLevel = "WARN";
                
                BEGIN_GPLOGGER_JSON_SERIALIZER
                    GPLOGGER_JSON_SERIALIZE("enable", bEnabled);
                    GPLOGGER_JSON_SERIALIZE("logLevel", LogLevel);
                END_GPLOGGER_JSON_SERIALIZER
            };
                
            struct FLogTypeFilter final : FGpLoggerJsonSerializable
            {
                bool bEnabled = false;
                TArray<FString> LogType;
                
                BEGIN_GPLOGGER_JSON_SERIALIZER
                    GPLOGGER_JSON_SERIALIZE("enable", bEnabled);
                    GPLOGGER_JSON_SERIALIZE_ARRAY("logType", LogType);
                END_GPLOGGER_JSON_SERIALIZER
            };
                
            struct FLogDuplicateFilter final : FGpLoggerJsonSerializable
            {
                bool bEnabled = false;
                int32 ExpiredTime = 2;
                
                BEGIN_GPLOGGER_JSON_SERIALIZER
                    GPLOGGER_JSON_SERIALIZE("enable", bEnabled);
                    GPLOGGER_JSON_SERIALIZE("expiredTime", ExpiredTime);
                END_GPLOGGER_JSON_SERIALIZER
            };

            FLogLevelFilter LogLevelFilter;
            FLogTypeFilter LogTypeFilter;
            FLogDuplicateFilter LogDuplicateFilter;
            
            BEGIN_GPLOGGER_JSON_SERIALIZER
                GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("logLevelFilter", LogLevelFilter);
                GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("logTypeFilter", LogTypeFilter);
                GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("logDuplicateFilter", LogDuplicateFilter);
            END_GPLOGGER_JSON_SERIALIZER
        };

        FLog Log;
        FLog Session;
        FLog Crash;
        FNetworkInsights NetworkInsights;
        FFilter Filter;
        
        BEGIN_GPLOGGER_JSON_SERIALIZER
            GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("log", Log);
            GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("session", Session);
            GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("crash", Crash);
            GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("networkinsights", NetworkInsights);
            GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("filter", Filter);
        END_GPLOGGER_JSON_SERIALIZER
    };
    
    int32 Status;
    FResult Result;
        
    BEGIN_GPLOGGER_JSON_SERIALIZER
        GPLOGGER_JSON_SERIALIZE("status", Status);
        GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("result", Result);
    END_GPLOGGER_JSON_SERIALIZER
    
};