#pragma once

#include "CoreMinimal.h"
#include "GameFramework/SaveGame.h"
#include "GpLoggerSaveData.generated.h"

struct FGpLoggerLogData;

USTRUCT()
struct FGpSaveLogData
{
    GENERATED_BODY()
    
    UPROPERTY()
    TMap<FString, FString> LogField;
};

USTRUCT()
struct FGpSaveBulkData
{
    GENERATED_BODY()
    
    UPROPERTY()
    TArray<FGpLoggerLogData> Logs;

    UPROPERTY()
    FString Uuid;
    
    UPROPERTY()
    FString SessionId;
};

UCLASS()
class UGpLoggerLogSave : public USaveGame
{
    GENERATED_BODY()

public:
    UPROPERTY(VisibleAnywhere, Category="GpLogger")
    FString Appkey;
    
    UPROPERTY(VisibleAnywhere, Category="GpLogger")
    EGpLoggerServiceZone ServiceZone;
    
    UPROPERTY(VisibleAnywhere, Category="GpLogger")
    TArray<FGpSaveBulkData> BulkLogs;
};