﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerEventListener.h"
#include "GpLoggerLogInfo.h"
#include "UObject/Object.h"
#include "GpLoggerLogSender.generated.h"

class UGpBaseLogger;
struct FGpLoggerTransferResult;

using FGpLogCollectorPtr = TSharedPtr<class FGpLoggerLogCollector>;
using FGpLogTransferPtr = TSharedPtr<class FGpLoggerLogTransfer>;
using FGpLogBackupStoragePtr = TSharedPtr<class FGpLoggerBackupStorage>;

UCLASS()
class UGpLoggerLogSender : public UObject
{
    GENERATED_BODY()
    
public:
    void Initialize();
    void Enqueue(const FGpLoggerLogData& LogData);
    void DirectSend(const FGpLoggerLogData& LogData);
    void DirectSend();

    struct FEventParams
    {
        FGpLoggerSuccessDelegate OnSuccessDelegate;
        FGpLoggerSaveDelegate OnSaveDelegate;
        FGpLoggerErrorDelegate OnErrorDelegate;
    };
    
    void SetListener(const FGpLoggerServiceData& Service, const FEventParams& Listener);
    
private:
    void OnBulkCreated(const FGpBulkLogDataRef& BulkLog) const;
    void OnTransferResult(const FGpLoggerTransferResult& Result);
    
private:
    FGpLogCollectorPtr LogCollector;
    FGpLogTransferPtr LogTransfer;
    FGpLogBackupStoragePtr LogBackupStorage;
    
    TMap<FGpLoggerServiceData, FEventParams> Events;
};
