﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerLogInfo.h"

enum class EGpLoggerServiceZone : uint8;
class IGpLoggerSettingLoader;
class IGpLoggerFilter;

class FGpLoggerLogCollector final
    : public FRunnable
    , public TSharedFromThis<FGpLoggerLogCollector>
{
    using FCollectQueue = TQueue<FGpLoggerLogData, EQueueMode::Mpsc>;
    using FServiceCollectMap = TMap<FGpLoggerServiceData, TSharedPtr<FCollectQueue>>;
    
public:
    explicit FGpLoggerLogCollector();
    virtual ~FGpLoggerLogCollector() override;
    
    void Enqueue(const FGpLoggerLogData& LogData);
    void DirectCollect();
    
    DECLARE_DELEGATE_OneParam(FOnBulkCreated, const FGpBulkLogDataRef& BulkLog);
    FOnBulkCreated& GetBulkCreatedDelegate() { return OnBulkCreated; }
    
    //~ FRunnable interface
    virtual bool Init() override;
    virtual uint32 Run() override;
    virtual void Stop() override;
    virtual void Exit() override;
    
    FORCEINLINE bool ShouldStop() const
    {
        return StopTaskCounter.GetValue() > 0;
    }

private:
    void Collect();
    
private:
    TUniquePtr<FRunnableThread> RunnableThread;
    FThreadSafeCounter StopTaskCounter;
    
    mutable FCriticalSection QueueLock;
    FServiceCollectMap Logs;
    
    FOnBulkCreated OnBulkCreated;
};