﻿#include "GpLoggerHelper.h"

#include "GpLoggerInternalTypes.h"
#include "GpLoggerLogInfo.h"

using namespace GpLogger;

namespace GpLoggerHelper
{
    const TSet<FString> LogEntrySkipFields = {
        LogField::ProjectKey,
        LogField::LogSource,
        LogField::LogVersion,
        LogField::UserID,
        LogField::ProjectVersion,
        LogField::DeviceID,
        LogField::PlatformName,
        LogField::LaunchedID,
        LogField::SdkVersion,
        LogField::SessionID,
        LogField::DeviceModel,
        LogField::CountryCode,
        LogField::LogBulkIndex,
        LogField::LogLevel,
        LogField::LogType,
        LogField::LogMessage,
        LogField::LogCreateTime,
        LogField::LogTransactionID
    };
}

FGpLogEntry GpLoggerHelper::ConvertLogEntry(const FGpLoggerLogData& LogItem)
{
    FGpLogEntry LogEntry;
    
    LogEntry.LogType = LogItem.GetLogType();
    LogEntry.LogLevel = LogItem.GetLogLevel();
    LogEntry.Message = LogItem.GetLogMessage();
    LogEntry.CreateTime = LogItem.GetCreateTime();
    LogEntry.TransactionId = LogItem.GetTransactionId();
    
    for (const FString& Field : LogItem.GetFields())
    {
        if (LogEntrySkipFields.Contains(Field) == false)
        {
            LogEntry.UserFields.Emplace(Field, LogItem.Get(Field));
        }
    }
    
    return LogEntry;
}

FString GpLoggerServerUrl::GetCollectorUrl(const EGpLoggerServiceZone ServiceZone)
{
    FString ZoneString;
    switch (ServiceZone)
    {
        case EGpLoggerServiceZone::Alpha:
            ZoneString = TEXT("alpha-");
            break;
        case EGpLoggerServiceZone::Beta:
            ZoneString = TEXT("beta-");
            break;
        default: ;
    }

    return FString::Printf(TEXT("https://%sapi-logncrash.cloud.toast.com/v2/log"), *ZoneString);
}
