﻿#pragma once

#include "CoreMinimal.h"
#include "GpBaseLogger.h"
#include "GpLoggerEventListener.h"
#include "GpLoggerLogInfo.h"
#include "GpStandaloneLogger.generated.h"

class IGpLoggerSettingLoader;
class FGpLoggerLogCollector;
class IGpLoggerFilter;

using IGpLoggerFilterPtr = TSharedPtr<IGpLoggerFilter>;

UCLASS()
class UGpStandaloneLogger : public UGpBaseLogger
{
    GENERATED_BODY()

public:
    virtual void Initialize(const FInitializeParams& Params) override;
    virtual void Log(EGpLogLevel Level, const FString& Message, const TMap<FString, FString>& UserFields) override;
    virtual void SetUserField(const FString& Key, const FString& Value) override;
    virtual void SetReserveField(const FString& Key, const FString& Value) override;
    virtual void SetListener(const FGpLoggerEventListener& Listener) override;
    virtual void Reporter(const FGpLoggerCrashInternalData& CrashData) override;

private:
    void Log(const FGpLoggerLogData& LogData, bool bIsDirectSend = false);

    void SendSessionLog();
    
protected:
    FGpLoggerServiceData ServiceData;
    FInitializeParams InitializeParams;
    
    TMap<FString, FString> BaseLogFields;
    TMap<FString, FString> SavedUserFields;

    TArray<IGpLoggerFilterPtr> Filters;
    
    FGpLoggerSuccessDelegate OnSuccessDelegate;
    FGpLoggerSaveDelegate OnSaveDelegate;
    FGpLoggerFilterDelegate OnFilterDelegate;
    FGpLoggerErrorDelegate OnErrorDelegate;
};
