﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerCoreSubsystem.h"
#include "GpLoggerStandaloneSubsystem.generated.h"

class UGpLoggerLogSender;

UCLASS()
class UGpLoggerStandaloneSubsystem : public UGpLoggerCoreSubsystem
{
    GENERATED_BODY()

public:
    static UGpLoggerLogSender* GetLogSender()
    {
        return LogSender;
    }
    
protected:
    virtual void Initialize(FSubsystemCollectionBase& Collection) override;
    virtual void Deinitialize() override;
    
    virtual UClass* GetLoggerClass() const override;
    virtual UClass* GetInstanceLoggerClass() const override;

private:
    static UGpLoggerLogSender* LogSender;
};
