﻿#include "GpLoggerStandaloneSubsystem.h"

#include "GpStandaloneLogger.h"
#include "Internal/GpLoggerLogSender.h"

UGpLoggerLogSender* UGpLoggerStandaloneSubsystem::LogSender = nullptr;

void UGpLoggerStandaloneSubsystem::Initialize(FSubsystemCollectionBase& Collection)
{
    Super::Initialize(Collection);

    if (LogSender == nullptr)
    {
        LogSender = NewObject<UGpLoggerLogSender>();
        LogSender->AddToRoot();
        LogSender->Initialize();
    }
}

void UGpLoggerStandaloneSubsystem::Deinitialize()
{
    Super::Deinitialize();

    if (GetSubsystemCount() == 1)
    {
        LogSender->RemoveFromRoot();
        LogSender = nullptr;
    }
}

UClass* UGpLoggerStandaloneSubsystem::GetLoggerClass() const
{
    return UGpStandaloneLogger::StaticClass();
}

UClass* UGpLoggerStandaloneSubsystem::GetInstanceLoggerClass() const
{
    return GetLoggerClass();
}