@echo off
setlocal enabledelayedexpansion

set TargetPlatform=%1
set TargetName=%2
set TargetType=%3
set TargetConfig=%4
set ProjectDir=%5
set PluginDir=%6

echo GPLogger: %TargetPlatform% %TargetName% %TargetType% %TargetConfig% %ProjectDir% %PluginDir%

if "%TargetType%"=="Editor" (
    echo GPLogger: Automatic symbol generation is not required in the editor. Skip to...
    exit /b 0
)

if NOT "%TargetPlatform%"=="Win64" (
    echo GPLogger: %TargetPlatform% is not supported. Skip to...
    exit /b 0
)

if /I "%TargetConfig%"=="Development" (
    set ResultFileName=%TargetName%
) else (
    set ResultFileName=%TargetName%-%TargetPlatform%-%TargetConfig%
)

set BasePath=%ProjectDir:"=%\Binaries\%TargetPlatform%
set PDBPath="%BasePath%\%ResultFileName%.pdb"
set SYMPath="%BasePath%\%ResultFileName%.sym"
set ZIPPath="%BasePath%\%ResultFileName%.sym.zip"

set DmpSymsFile="%PluginDir:"=%\Source\GpLoggerStandalone\ThirdParty\dump_syms.exe"

if not exist "%PDBPath%" (
    echo GPLogger: Warning: %PDBPath% is not found. Skip to...
    exit /b 0
)

echo GPLogger: Running dump_syms.exe to generate .sym file...
"%DmpSymsFile%" "%PDBPath%" > "%SYMPath%"

if %errorlevel% neq 0 (
    echo Error: GPLogger: Failed to generate .sym file.
    exit /b %errorlevel%
)

echo Compressing .sym file into a .zip archive...
powershell Compress-Archive -Path "%SYMPath%" -DestinationPath "%ZIPPath%" -Force

if %errorlevel% neq 0 (
    echo Warning: GPLogger: Failed to compress .sym file.
    exit /b 0
)

echo GPLogger: Process completed successfully.

endlocal
pause