﻿using System;
using System.IO;
using System.Linq;
using UnrealBuildTool;

public class GpLoggerStandalone : ModuleRules
{
    public GpLoggerStandalone(ReadOnlyTargetRules Target) : base(Target)
    {
        PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;

        PrivateDependencyModuleNames.AddRange(
            new[]
            {
                "Core",
                "CoreUObject",
                "Engine",
                "Projects",
                "Json",
                "JsonUtilities",
                "HTTP",
                "GpLogger",
                "GpLoggerCore",
            }
        );
        
        if (Target.Platform == UnrealTargetPlatform.Win64)
        {
            var thirdPartyPath = Path.GetFullPath(Path.Combine(ModuleDirectory, "ThirdParty", Target.Platform.ToString()));
            var binariesPath = Path.GetFullPath(Path.Combine(PluginDirectory, "Binaries", Target.Platform.ToString()));

            var dependencyExtensions = new[] { ".exe" };
            var dependencyFiles = Directory.EnumerateFiles(thirdPartyPath, "*.*", SearchOption.AllDirectories)
                .Where(file => dependencyExtensions.Any(ext => file.EndsWith(ext, StringComparison.OrdinalIgnoreCase)));

            foreach (var filePath in dependencyFiles)
            {
                RuntimeDependencies.Add(Path.Combine(binariesPath, GetRelativePath(thirdPartyPath, filePath)), filePath);
            }
        }
        else
        {
            Console.WriteLine("[GpLoggerStandalone] {0} is not supported.", Target.Platform);
        }
    }
    
    private static string GetRelativePath(string baseDir, string filePath)
    {
        Uri baseUri = new Uri(baseDir.TrimEnd(Path.DirectorySeparatorChar) + Path.DirectorySeparatorChar);
        Uri fileUri = new Uri(filePath);
        return Uri.UnescapeDataString(baseUri.MakeRelativeUri(fileUri).ToString().Replace('/', Path.DirectorySeparatorChar));
    }
}