#pragma once

namespace GpLogger
{
    template<typename T>
    FString EnumToString(const T EnumValue)
    {
        return StaticEnum<T>()->GetNameStringByValue(static_cast<int64>(EnumValue));
    }
    
    template<typename T>
    T StringToEnum(const FString& NameString)
    {
        return static_cast<T>(StaticEnum<T>()->GetValueByNameString(NameString));
    }

    inline int64 GetEpochTimeMs()
    {
        const auto CurrentTime = FDateTime::UtcNow() - FDateTime(1970, 1, 1);
        return CurrentTime.GetTotalMilliseconds();
    }
}