﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerInternalCrashTypes.h"
#include "Subsystems/EngineSubsystem.h"
#include "GpLoggerEngineSubsystem.generated.h"

struct FGpLoggerCrashInternalData;
struct FGpLoggerCrashData;
struct FGpLoggerCrashListener;
class FGpLoggerCrashManager;

UCLASS()
class GPLOGGERCORE_API UGpLoggerEngineSubsystem : public UEngineSubsystem
{
    GENERATED_BODY()
    
public:
    struct FCrashInitializeParams
    {
        bool bEnableReporter = false;
        bool bEnableErrorLog = false;
    };
    
    void InitializeCrash(const FCrashInitializeParams& Params);
    FGpLoggerCrashDelegate& GetCrashDelegate() const;
    
    FString GetPlatform() const { return Platform; }
    FString GetSessionId() const { return SessionId; }
    FString GetLaunchedId() const { return LaunchedId; }
    FString GetDeviceModel() const { return DeviceModel; }
    FString GetDeviceId() const { return DeviceId; }
    FString GetCountryCode() const { return CountryCode; }
    
protected:
    // USubsystem interface
    virtual void Initialize(FSubsystemCollectionBase& Collection) override;
    virtual void Deinitialize() override;
    // ~USubsystem interface

private:
    TSharedPtr<FGpLoggerCrashManager> CrashManager;
    
    FDelegateHandle OnSystemErrorDelegateHandle;
    
    FString Platform;
    FString SessionId;
    FString LaunchedId;
    FString DeviceModel;
    FString DeviceId;
    FString CountryCode;
};