#pragma once

#include "CoreMinimal.h"

GPLOGGERCORE_API DECLARE_LOG_CATEGORY_EXTERN(LogGpLogger, Log, All);

#define LOG_MESSAGE(Format, ...) \
    *FString::Printf(TEXT("[GpLogger] %s : %s"), ANSI_TO_TCHAR(__FUNCTION__), *FString::Printf(TEXT(Format), ##__VA_ARGS__))

#define GPLOGGER_LOG_DEBUG(Format, ...) \
    UE_LOG(LogGpLogger, Display, TEXT("%s"), LOG_MESSAGE(Format, ##__VA_ARGS__));

#define GPLOGGER_LOG_WARNING(Format, ...) \
    UE_LOG(LogGpLogger, Warning, TEXT("%s"), LOG_MESSAGE(Format, ##__VA_ARGS__));

#define GPLOGGER_LOG_ERROR(Format, ...) \
    UE_LOG(LogGpLogger, Error, TEXT("%s"), LOG_MESSAGE(Format, ##__VA_ARGS__));
