﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerConfiguration.h"
#include "GpLoggerLogInfo.h"
#include "GpLoggerTypes.h"
#include "UObject/Object.h"
#include "GpBaseLogger.generated.h"

struct FGpLoggerLogData;
struct FGpLoggerCrashInternalData;
struct FGpLoggerEventListener;
DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnCalculationComplete, int32, Result);

UENUM()
enum class EGpLoggerSettingType
{
    Default,
    Console,
};

UCLASS(Abstract)
class GPLOGGERCORE_API UGpBaseLogger : public UObject
{
    GENERATED_BODY()
    
public: 
    struct FInitializeParams
    {
        FString Appkey;
        EGpLoggerSettingType SettingType = EGpLoggerSettingType::Default;
        EGpLoggerServiceZone ServiceZone = EGpLoggerServiceZone::Real;
        bool bIsCrashReporter = false;
    };
    
    virtual void Initialize(const FInitializeParams& Params)
    PURE_VIRTUAL(UGpBaseLogger::Initialize,);
    
    virtual void Log(EGpLogLevel Level, const FString& Message, const TMap<FString, FString>& UserFields)
    PURE_VIRTUAL(UGpBaseLogger::Log,);
    
    virtual void SetUserField(const FString& Key, const FString& Value)
    PURE_VIRTUAL(UGpBaseLogger::SetUserField,);
    
    virtual void SetListener(const FGpLoggerEventListener& EventListener)
    PURE_VIRTUAL(UGpBaseLogger::SetListener,);

    virtual void Reporter(const FGpLoggerCrashInternalData& CrashData)
    PURE_VIRTUAL(UGpBaseLogger::CrashReporter,);
    
    virtual void SetReserveField(const FString& Key, const FString& Value);
    
    virtual FGpLoggerServiceData GetServiceData() const;
    
protected:
    UGameInstance* GetGameInstance() const;
};
