#pragma once

#include "Utils/GpLoggerJsonMacros.h"

namespace GpLoggerProtocol
{
    struct FBasePayload : FGpLoggerJsonSerializable
    {
        virtual ~FBasePayload() override {}
        virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override {}
    };
            
    template <typename InPayloadType = FBasePayload>
    struct TBridgeProtocol : FGpLoggerJsonSerializable
    {
        FString Uri;
        TMap<FString, FString> Header;
        InPayloadType Payload;

        explicit TBridgeProtocol(const FString& Uri)
            : Uri(Uri)
        {
            Header.Add(TEXT("transactionId"), FGuid::NewGuid().ToString());
        }
        
        explicit TBridgeProtocol(const FString& Uri, const InPayloadType Payload)
            : Uri(Uri), Payload(Payload)
        {
            Header.Add(TEXT("transactionId"), FGuid::NewGuid().ToString());
        }
    
        BEGIN_GPLOGGER_JSON_SERIALIZER
            GPLOGGER_JSON_SERIALIZE("uri", Uri);
            GPLOGGER_JSON_SERIALIZE_MAP("header", Header);
            GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("payload", Payload);
        END_GPLOGGER_JSON_SERIALIZER
    };
}