#include "IGpLoggerBridge.h"
#include "Protocols/GpLoggerProtocolDebugMode.h"

using namespace GpLoggerProtocol;

void IGpLoggerNativeBridge::SetDebugMode(const bool bIsDebugMode)
{
    SendMessage(FSetDebugModeRequest(bIsDebugMode).ToJson(false));
}

bool IGpLoggerNativeBridge::GetDebugMode()
{
    FGetDebugModeResponse Response;
    Response.FromJson(SendMessage(FGetDebugModeRequest().ToJson()));
    return Response.bDebugMode;
}