﻿#pragma once

#include "CoreMinimal.h"
#include "GpBaseLogger.h"
#include "GpLoggerEventListener.h"
#include "GpBridgeLogger.generated.h"

UCLASS()
class UGpBridgeLogger : public UGpBaseLogger
{
    GENERATED_UCLASS_BODY()

public:
    static UGpBridgeLogger* Get() { return SingletonInstance; }
    
    virtual void Initialize(const FInitializeParams& Params) override;
    virtual void Log(EGpLogLevel Level, const FString& Message, const TMap<FString, FString>& UserFields) override;
    virtual void SetUserField(const FString& Key, const FString& Value) override;
    virtual void SetListener(const FGpLoggerEventListener& Listener) override;
    virtual void Reporter(const FGpLoggerCrashInternalData& CrashData) override;

    void ReceiveMessage(const FString& Method, const FString& JsonString) const;
    
private:
    static UGpBridgeLogger* SingletonInstance;
    
    FGpLoggerSuccessDelegate OnSuccessDelegate;
    FGpLoggerSaveDelegate OnSaveDelegate;
    FGpLoggerFilterDelegate OnFilterDelegate;
    FGpLoggerErrorDelegate OnErrorDelegate;
};

UCLASS()
class UGpBridgeInstanceLogger : public UGpBaseLogger
{
    GENERATED_BODY()

public:
    virtual void Initialize(const FInitializeParams& Params) override;
    virtual void Log(EGpLogLevel Level, const FString& Message, const TMap<FString, FString>& UserFields) override;
    virtual void SetUserField(const FString& Key, const FString& Value) override;
    virtual void SetListener(const FGpLoggerEventListener& EventListener) override;
    virtual void Reporter(const FGpLoggerCrashInternalData& CrashData) override;

private:
    FString Appkey;
};
