﻿#pragma once

#include "CoreMinimal.h"
#include "IGpLoggerBridge.h"

#if USE_ANDROID_JNI

class FGpLoggerAndroidBridge final : public IGpLoggerNativeBridge
{
public:
    FGpLoggerAndroidBridge() {}
    virtual ~FGpLoggerAndroidBridge() override = default;
    
    virtual FString SendMessage(const FString& JsonString) override;
};

#else

class FGpLoggerAndroidBridge final : public IGpLoggerNativeBridge
{
public:
    FGpLoggerAndroidBridge() {}
    virtual ~FGpLoggerAndroidBridge() override = default;
    
    virtual FString SendMessage(const FString& JsonString) override { return {}; }
};
#endif