﻿#include "GpLoggerAndroidBridge.h"

#if USE_ANDROID_JNI

#include "GPLoggerDefines.h"
#include "GpBridgeLogger.h"
#include "Android/AndroidApplication.h"

#define NATIVE_CLASS "com/nhncloud/android/gameplatform/logger/NhnCloudUnity"

FString FGpLoggerAndroidBridge::SendMessage(const FString& JsonString)
{
    FString Result;

    JNIEnv* Env = FAndroidApplication::GetJavaEnv();
    if (Env != nullptr)
    {
        jclass PluginClass = FAndroidApplication::FindJavaClassGlobalRef(NATIVE_CLASS);
        if (PluginClass != nullptr)
        {
            jmethodID ResultMessage = Env->GetStaticMethodID(PluginClass, "unityMessage", "(Ljava/lang/String;)Ljava/lang/String;");
            
            GPLOGGER_LOG_DEBUG("%s", *JsonString);
            
            auto jJsonString = FJavaHelper::ToJavaString(Env, JsonString);
            Result = FJavaHelper::FStringFromLocalRef(Env, (jstring)Env->CallStaticObjectMethod(PluginClass, ResultMessage, *jJsonString));

            Env->DeleteGlobalRef(PluginClass);
        }
    }
    
    GPLOGGER_LOG_DEBUG("result: %s", *Result);

    return Result;
}

JNI_METHOD void Java_com_nhncloud_android_gameplatform_logger_engine_UnityReflection_nativeSendMessage(JNIEnv* jenv, jobject thiz, jstring MethodName, jstring JsonString)
{
    if (UGpBridgeLogger* Logger = UGpBridgeLogger::Get())
    {
        Logger->ReceiveMessage(FJavaHelper::FStringFromParam(jenv, MethodName), FJavaHelper::FStringFromParam(jenv, JsonString));
    }
}

#endif