#pragma once

#include "GpLoggerTypes.generated.h"

UENUM(BlueprintType)
enum class EGpLogLevel : uint8
{
    Debug,
    Info,
    Warn,
    Error,
    Fatal,
    None
};

USTRUCT(BlueprintType)
struct GPLOGGER_API FGpLogEntry
{
    GENERATED_BODY()

    UPROPERTY()
    FString LogType;
    
    UPROPERTY()
    EGpLogLevel LogLevel;

    UPROPERTY()
    FString Message;
    
    UPROPERTY()
    FString TransactionId;
    
    UPROPERTY()
    int64 CreateTime;
    
    UPROPERTY()
    TMap<FString, FString> UserFields;

    FGpLogEntry() = default;
    FGpLogEntry(const FString& Type, const EGpLogLevel Level, const FString& Message, const TMap<FString, FString>& UserFields)
        : LogType(Type)
        , LogLevel(Level)
        , Message(Message)
        , CreateTime(0)
        , UserFields(UserFields)
    {
    }
};

USTRUCT(BlueprintType)
struct GPLOGGER_API FGpLogFilter
{
    GENERATED_BODY()

    UPROPERTY()
    FString Name;
};