﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerConfiguration.generated.h"

UENUM(BlueprintType)
enum class EGpLoggerServiceZone : uint8
{
    Alpha = 0,
    Beta = 1,
    Real = 2
};

USTRUCT(BlueprintType)
struct GPLOGGER_API FGpLoggerConfiguration
{
    GENERATED_BODY()

    UPROPERTY()
    FString Appkey;
    
    UPROPERTY()
    bool bEnableCrashReporter;
    
    UPROPERTY()
    bool bEnableCrashErrorLog;
    
    UPROPERTY(meta = (DefaultValue = "Real", PinHiddenByDefault))
    EGpLoggerServiceZone ServiceZone = EGpLoggerServiceZone::Real;
};