//
//  NHNCloud+Private.h
//  GamebasePurchaseIAPAdapter
//
//  Created by NHN on 2022/12/23.
//  Copyright © 2022 NHN Corp. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <NHNCloudIAP/NHNCloudIAP.h>
#import <NHNCloudCommon/NHNCloudCommon.h>

NS_ASSUME_NONNULL_BEGIN

@interface NHNCloudPurchaseResult ()

@property (nonatomic, readonly, nullable) NHNCloudDictionary *extraData;

@end


@interface NHNCloudIAP ()

+ (void)purchaseWithProduct:(NHNCloudProduct *)product
                    payload:(nullable NSString *)payload
                  extraData:(nullable NSDictionary<NSString *, NSString *> *)extraData
    NS_SWIFT_NAME(purchase(product:payload:extraData:));

+ (void)purchaseWithProductIdentifier:(NSString *)productIdentifier
                              payload:(nullable NSString *)payload
                            extraData:(nullable NSDictionary<NSString *, NSString *> *)extraData
    NS_SWIFT_NAME(purchase(productIdentifier:payload:extraData:));

@end

NS_ASSUME_NONNULL_END
