//
//  TCGBUpdateInfo.h
//  Gamebase
//
//  Created by NHNEnt on 2020/02/25.
//  Copyright © 2020 NHN Corp. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Gamebase/TCGBExtraInfoProtocol.h>
#import <Gamebase/TCGBError.h>
#import <Gamebase/TCGBError+Ex.h>

NS_ASSUME_NONNULL_BEGIN

extern NSString* const kTCGBUpdateInfoKeyname;
extern NSString* const kTCGBUpdateInfoInstallUrlKeyname;
extern NSString* const kTCGBUpdateInfoMessageKeyname;

@interface TCGBUpdateInfo : NSObject <TCGBExtraInfoProtocol>

@property (nonatomic, strong, nullable) NSString* installUrl;
@property (nonatomic, strong, nullable) NSString* message;

+ (nullable TCGBUpdateInfo *)updateInfoFromError:(TCGBError *)error
    NS_SWIFT_NAME(updateInfo(fromError:));

+ (nullable TCGBUpdateInfo *)updateInfoFromDictionary:(NSDictionary *)dic
    NS_SWIFT_NAME(updateInfo(fromDictionary:));

- (instancetype)init __attribute__((unavailable("init not available.")))
    NS_SWIFT_NAME(init());

- (instancetype)initFromError:(TCGBError *)error
    NS_SWIFT_NAME(init(fromError:));

@end

NS_ASSUME_NONNULL_END
