//
//  TCGBTransferAccountRenewConfiguration.h
//  Gamebase
//
//  Created by NHN on 07/02/2019.
//  © NHN Corp. All rights reserved.
//
#import <Foundation/Foundation.h>
#import <Gamebase/TCGBTransferAccountConstants.h>

#ifndef TCGBTransferAccountRenewConfiguration_h
#define TCGBTransferAccountRenewConfiguration_h

NS_ASSUME_NONNULL_BEGIN

@interface TCGBTransferAccountRenewConfiguration : NSObject

@property (nonatomic, assign) TCGBTransferAccountRenewalModeType renewalMode;
@property (nonatomic, assign) TCGBTransferAccountRenewalTargetType renewalTarget;
@property (nonatomic, strong, nullable) NSString* accountId;
@property (nonatomic, strong, nullable) NSString* accountPassword;

- (instancetype)init __attribute__((unavailable("init not available")))
    NS_SWIFT_NAME(init());

- (instancetype)initWithRenewalMode:(TCGBTransferAccountRenewalModeType)renewalMode
                      renewalTarget:(TCGBTransferAccountRenewalTargetType)renewalTarget
                          accountId:(nullable NSString *)accountId
                    accountPassword:(nullable NSString *)accountPassword
    NS_SWIFT_NAME(init(renewalMode:renewalTarget:accountId:accountPassword:));

+ (TCGBTransferAccountRenewConfiguration *)autoRenewConfigurationWithRenewalTarget:(TCGBTransferAccountRenewalTargetType)renewalTarget
    NS_SWIFT_NAME(autoRenewConfiguration(renewalTarget:));

+ (TCGBTransferAccountRenewConfiguration *)manualRenewConfigurationWithAccountPassword:(NSString *)accountPassword
    NS_SWIFT_NAME(manualRenewConfiguration(accountPassword:));

+ (TCGBTransferAccountRenewConfiguration *)manualRenewConfigurationWithAccountId:(NSString *)accountId
                                                              accountPassword:(NSString *)accountPassword
    NS_SWIFT_NAME(manualRenewConfiguration(accountId:accountPassword:));

- (NSString *)JSONString
    NS_SWIFT_NAME(JSONString());

- (NSString *)JSONPrettyString
    NS_SWIFT_NAME(JSONPrettyString());

@end

NS_ASSUME_NONNULL_END

#endif /* TCGBTransferAccountRenewConfiguration_h */
