//
//  TCGBTermsConfiguration.h
//  Gamebase
//
//  Created by NHN on 2022/01/17.
//  Copyright © 2022 NHN Corp. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Gamebase/TCGBValueObject.h>

NS_ASSUME_NONNULL_BEGIN

@interface TCGBTermsConfiguration : NSObject <TCGBValueObject>

/**
 Set whether to force the termsView to be displayed.
 The default value is NO;
 */
@property (nonatomic, assign) BOOL forceShow;

+ (nullable instancetype)termsConfigurationWithJSONString:(NSString *)jsonString
    NS_SWIFT_NAME(termsConfiguration(jsonString:));
                  
- (NSString *)jsonString
    NS_SWIFT_NAME(jsonString());

- (NSString *)prettyJsonString
    NS_SWIFT_NAME(prettyJsonString());

@end

NS_ASSUME_NONNULL_END
