//
//  TCGBServerPushMessage.h
//  Gamebase
//
//  Created by NHN on 2018. 2. 5..
//  © NHN Corp. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class TCGBWebSocketResponseProtocol;

@interface TCGBServerPushMessage : NSObject {
    @private
    NSDictionary*   _serverPush;
    NSDictionary*   _popup;
    
}
@property (nonatomic, strong)   NSString*       type;           // type
@property (nonatomic, strong)   NSString*       data;           // data.result

+ (TCGBServerPushMessage *)serverPushMessageWithType:(NSString *)type
                                                data:(NSString *)data
                                               popup:(nullable NSDictionary<NSString *, id> *)popup
                                          serverPush:(nullable NSDictionary<NSString *, id> *)serverPush
    NS_SWIFT_NAME(serverPushMessage(type:data:popup:serverPush:));

+ (TCGBServerPushMessage *)serverPushMessageWithResponseData:(TCGBWebSocketResponseProtocol *)responseData
    NS_SWIFT_NAME(serverPushMessage(responseData:));
+ (TCGBServerPushMessage *)serverPushMessageForReceivedWithResponseData:(TCGBWebSocketResponseProtocol *)responseData
    NS_SWIFT_NAME(serverPushMessageForReceived(responseData:));

@end

NS_ASSUME_NONNULL_END
