//
//  TCGBPushConfiguration.h
//  Gamebase
//
//  Created by NHNEnt on 28/08/2019.
//  Copyright © 2019 NHN Corp. All rights reserved.
//

#ifndef TCGBPushConfiguration_h
#define TCGBPushConfiguration_h

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class TCGBDataContainer;

/** The TCGBPushConfiguration class configures the behavior of TCGBPush.
 */
@interface TCGBPushConfiguration : NSObject

/**---------------------------------------------------------------------------------------
 * @name Properties
 *  ---------------------------------------------------------------------------------------
 */

/**
 Enable push
 */
@property (nonatomic, assign) BOOL pushEnabled;

/**
 Agreement of getting advertising push
 */
@property (nonatomic, assign) BOOL ADAgreement;

/**
 Agreement of getting advertising push at night
 */
@property (nonatomic, assign) BOOL ADAgreementNight;

/**
 Setting language of Push Message
 */
@property (nonatomic, strong, nullable) NSString* displayLanguageCode;

/**
 Set whether to register a token even if permission to allow notifications is not obtained.
 
 @warning Default value is NO.
 */
@property (nonatomic, assign) BOOL alwaysAllowTokenRegistration;

/**---------------------------------------------------------------------------------------
 * @name Initialization
 *  ---------------------------------------------------------------------------------------
 */

/**
 Creates a TCGBPushConfiguration instance with several properties.
 
 @param enable whether push enable or not.
 @param ADAgree `YES` if user agree on advertising push notification.
 @param ADAgreeNight `YES` if user agree on getting advertising push notification at night.
 */
+ (instancetype)pushConfigurationWithPushEnable:(BOOL)enable
                                    ADAgreement:(BOOL)ADAgree
                               ADAgreementNight:(BOOL)ADAgreeNight
    NS_SWIFT_NAME(pushConfiguration(pushEnable:ADAgreement:ADAgreementNight:));

/**
 Creates a TCGBPushConfiguration instance with several properties.
 
 @param enable whether push enable or not.
 @param ADAgree `YES` if user agree on advertising push notification.
 @param ADAgreeNight `YES` if user agree on getting advertising push notification at night.
 @param alwaysAllowTokenRegistration When set to `YES`, the token is registered even if permission to grant notifications is not obtained. Default value is `NO`
 */
+ (instancetype)pushConfigurationWithPushEnable:(BOOL)enable
                                    ADAgreement:(BOOL)ADAgree
                               ADAgreementNight:(BOOL)ADAgreeNight
                   alwaysAllowTokenRegistration:(BOOL)alwaysAllowTokenRegistration
    NS_SWIFT_NAME(pushConfiguration(pushEnable:ADAgreement:ADAgreementNight:alwaysAllowTokenRegistration:));

/**
 Creates a TCGBPushConfiguration instance with several properties.
 
 @param enable whether push enable or not.
 @param ADAgree `YES` if user agree on advertising push notification.
 @param ADAgreeNight `YES` if user agree on getting advertising push notification at night.
 @param displayLanguage set language code for Push. (kTCPushKeyLanguage in NHNCloud Push SDK)
 */
+ (instancetype)pushConfigurationWithPushEnable:(BOOL)enable
                                    ADAgreement:(BOOL)ADAgree
                               ADAgreementNight:(BOOL)ADAgreeNight
                                displayLanguage:(nullable NSString *)displayLanguage
    NS_SWIFT_NAME(pushConfiguration(pushEnable:ADAgreement:ADAgreementNight:displayLanguage:));

/**
 Creates a TCGBPushConfiguration instance with several properties.
 
 @param enable whether push enable or not.
 @param ADAgree `YES` if user agree on advertising push notification.
 @param ADAgreeNight `YES` if user agree on getting advertising push notification at night.
 @param displayLanguage set language code for Push. (kTCPushKeyLanguage in NHNCloud Push SDK)
 @param alwaysAllowTokenRegistration When set to `YES`, the token is registered even if permission to grant notifications is not obtained. Default value is `NO`
 */
+ (instancetype)pushConfigurationWithPushEnable:(BOOL)enable
                                    ADAgreement:(BOOL)ADAgree
                               ADAgreementNight:(BOOL)ADAgreeNight
                                displayLanguage:(nullable NSString *)displayLanguage
                   alwaysAllowTokenRegistration:(BOOL)alwaysAllowTokenRegistration
    NS_SWIFT_NAME(pushConfiguration(pushEnable:ADAgreement:ADAgreementNight:displayLanguage:alwaysAllowTokenRegistration:));

/**
 Creates a TCGBPushConfiguration instance with several properties.
 @param jsonString In this string, there should be `pushEnabled`, `adAgreement`, `adAgreementNight` keys in the json formatted string.
 */
+ (nullable instancetype)pushConfigurationWithJSONString:(NSString *)jsonString
    NS_SWIFT_NAME(pushConfiguration(jsonString:));

+ (nullable instancetype)fromDataContainer:(TCGBDataContainer *)dataContainer
    NS_SWIFT_NAME(fromDataContainer(_:));

- (NSString *)JSONString
    NS_SWIFT_NAME(JSONString());

- (NSString *)JSONPrettyString
    NS_SWIFT_NAME(JSONPrettyString());

- (NSDictionary<NSString *, id> *)dictionary
    NS_SWIFT_NAME(dictionary());

@end

NS_ASSUME_NONNULL_END

#endif /* TCGBPushConfiguration_h */
	
