//
//  TCGBPushAgreement.h
//  Gamebase
//
//  Created by NHN on 2020/08/10.
//  Copyright © 2020 NHN Corp. All rights reserved.
//

#ifndef TCGBPushAgreement_h
#define TCGBPushAgreement_h

#import <Foundation/Foundation.h>
#import <Gamebase/TCGBValueObject.h>

NS_ASSUME_NONNULL_BEGIN

@interface TCGBPushAgreement : NSObject <TCGBValueObject>

@property (nonatomic, assign) BOOL pushEnabled;
@property (nonatomic, assign) BOOL ADAgreement;
@property (nonatomic, assign) BOOL ADAgreementNight;

+ (TCGBPushAgreement *)pushAgreementWithPushEnabled:(BOOL)pushEnabled ADAgreement:(BOOL)ADAgreement ADAgreementNight:(BOOL)ADAgreementNight
    NS_SWIFT_NAME(pushAgreement(pushEnabled:ADAgreement:ADAgreementNight:));

- (instancetype)initWithPushEnabled:(BOOL)pushEnabled ADAgreement:(BOOL)ADAgreement ADAgreementNight:(BOOL)ADAgreementNight
    NS_SWIFT_NAME(init(pushEnabled:ADAgreement:ADAgreementNight:));

+ (nullable TCGBPushAgreement *)pushAgreementWithJSONString:(NSString *)jsonString
    NS_SWIFT_NAME(pushAgreement(jsonString:));

- (NSString *)jsonString
    NS_SWIFT_NAME(jsonString());

- (NSString *)prettyJsonString
    NS_SWIFT_NAME(prettyJsonString());

@end

NS_ASSUME_NONNULL_END

#endif /* TCGBPushAgreement_h */
