//
//  TCGBPurchasableReceipt.h
//  Gamebase
//
//  Created by Philip Chung on 2023/02/16
//  Copyright © 2023 NHN Corp. All rights reserved.
//
        

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/** The TCGBPurchasableReceipt class represent a receipt that is from the IAP Server.
 */
@interface TCGBPurchasableReceipt : NSObject

/**---------------------------------------------------------------------------------------
 * @name Properties
 *  ---------------------------------------------------------------------------------------
 */

/** storeCode
 */
@property (nonatomic, strong) NSString *storeCode;

/** itemSeq
 
 Item Sequence which is the number presented in NHN Cloud IAP Console.
 */
@property (assign)            long itemSeq;

/** marketItemId
 
 ItemID which is registered at market(itunesconnect).
 */
@property (nonatomic, strong) NSString *marketItemId;

/** gamebaseProductId

productID which is registered at IAP Console
*/
@property (nonatomic, strong) NSString *gamebaseProductId;

/** item price
 
 This value is from the market.
 @warning If there is no price data, it will be initialized to -1
 */
@property (assign)            float price;

/** currency
 */
@property (nonatomic, strong) NSString *currency;

/** paymentSeq
 
 Payment Sequence is used to trace purchase transaction.
 */
@property (nonatomic, strong) NSString *paymentSeq;

/** purchaseToken
 
 Purchase Token is an unique string to validate purchasement.
 */
@property (nonatomic, strong) NSString *purchaseToken;

/** productType

This string value represent type of product. (CONSUMABLE, UNKNOWN, AUTO_RENEWABLE, CONSUMABLE_AUTO_RENEWABLE)
*/
@property (nonatomic, strong) NSString *productType;

/** userId
 */
@property (nonatomic, strong) NSString *userId;

/** paymentId
 */
@property (nonatomic, strong, nullable) NSString *paymentId;

/** originalPaymentId
 */
@property (nonatomic, strong, nullable) NSString *originalPaymentId;

/** purchaseTime
 */
@property (nonatomic, assign) long purchaseTime;

/**expiryTime
 */
@property (nonatomic, assign) long expiryTime;

/**userPayload
 */
@property (nonatomic, strong, nullable) NSString *payload;

/**sandboxPayment
 */
@property (nonatomic, assign) BOOL sandboxPayment;

/**promotionPayment
 */
@property (nonatomic, assign) BOOL promotionPayment;


/**---------------------------------------------------------------------------------------
 * @name Allocation
 *  ---------------------------------------------------------------------------------------
 */

- (instancetype)initWithStoreCode:(NSString *)storeCode 
                          itemSeq:(long)itemSeq
                     marketItemId:(NSString *)marketItemId
                gamebaseProductId:(NSString *)gamebaseProductId
                            price:(float)price
                         currency:(NSString *)currency
                       paymentSeq:(NSString *)paymentSeq
                    purchaseToken:(NSString *)purchaseToken
                      productType:(NSString *)productType
                           userId:(NSString *)userId
                        paymentId:(nullable NSString *)paymentId
                originalPaymentId:(nullable NSString *)originalPaymentId
                     purchaseTime:(long)purchaseTime
                       expiryTime:(long)expiryTime
                          payload:(nullable NSString *)payload
                   sandboxPayment:(BOOL)sandboxPayment
                 promotionPayment:(BOOL)promotionPayment;

- (instancetype)purchasableReceiptWithResult:(NSDictionary<NSString *, id> *)result
    NS_SWIFT_NAME(purchasableReceipt(result:));
+ (instancetype)purchasableReceiptFromJsonString:(NSString *)jsonString
    NS_SWIFT_NAME(purchasableReceipt(jsonString:));

- (NSDictionary *)dictionary;

- (NSString *)JSONString
    NS_SWIFT_NAME(JSONString());

- (NSString *)JSONPrettyString
    NS_SWIFT_NAME(JSONPrettyString());

@end

NS_ASSUME_NONNULL_END
