//
//  TCGBPurchasableItem.h
//  Gamebase
//
//  Created by Philip Chung on 2023/02/16
//  Copyright © 2023 NHN Corp. All rights reserved.
//
        

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/** The TCGBPurchasableItem class is VO class of item entity.
 */
@interface TCGBPurchasableItem : NSObject

/**---------------------------------------------------------------------------------------
 * @name Properties
 *  ---------------------------------------------------------------------------------------
 */

/** itemSeq
 
 Item Sequence which is the number presented in NHN Cloud IAP Console.
*/
@property (assign)            long itemSeq;

/** item price
 
 This value is from the market.
 @warning If there is no price data, it will be initialized to -1
 */
@property (assign)            float price;

/** item name
 
 Item name is from NHN Cloud IAP Console.
 */
@property (nonatomic, strong) NSString *itemName;

/** marketId
 
 which is actually **AS**.
 */
@property (nonatomic, strong) NSString *marketId;

/** marketItemId
 
 ItemID which is registered at market(itunesconnect).
 */
@property (nonatomic, strong) NSString *marketItemId;

/** gamebaseProductId

ItemID which is registered at IAP Console.
*/
@property (nonatomic, strong) NSString *gamebaseProductId;

/** currency
 currency which is registered at market.
*/
@property (nonatomic, strong) NSString *currency;

/** usingStatus
 
 This string value represent if this item is available.
 */
@property (nonatomic, strong) NSString *usingStatus;

/** localizedPrice
 
 This string value represent price with currency.
 */
@property (nonatomic, strong) NSString *localizedPrice;

/** localizedTitle
 localizedTitle which is registered at market.
*/
@property (nonatomic, strong) NSString *localizedTitle;

/** localizedDescription
 localizedDescription which is registered at market.
*/
@property (nonatomic, strong) NSString *localizedDescription;

/** productType
 
 This string value represent type of product. (CONSUMABLE, UNKNOWN, AUTO_RENEWABLE, CONSUMABLE_AUTO_RENEWABLE)
 */

@property (nonatomic, strong) NSString *productType;

/** active
 
 This boolean value represent
 */
@property (nonatomic, assign, getter=isActive) BOOL active;

/**---------------------------------------------------------------------------------------
 * @name Allocation
 *  ---------------------------------------------------------------------------------------
 */

/** Initialize the class with JSON Value.
 
 @param result  result is a json formatted NSDictionary object. This is from Gamebase Server.
 @return    Instance being initialized.
 */
+ (instancetype)gamebaseProductWithDictionary:(NSDictionary<NSString *, id> *)result
    NS_SWIFT_NAME(gamebaseProduct(dictionary:));

- (instancetype)initWithItemSeq:(long)itemSeq
                          price:(float)price
                       itemName:(NSString *)itemName
                    usingStatus:(NSString *)usingStatus
                       marketId:(NSString *)marketId
                   marketItemId:(NSString *)marketItemId
              gamebaseProductId:(NSString *)gamebaseProductId
                       currency:(NSString *)currency
                 localizedPrice:(NSString *)localizedPrice
                 localizedTitle:(NSString *)localizedTitle
           localizedDescription:(NSString *)localizedDescription
                    productType:(NSString *)productType
                         active:(BOOL)active;

- (instancetype)initWithDictionary:(NSDictionary<NSString *, id> *)result
    NS_SWIFT_NAME(init(dictionary:));

- (NSDictionary<NSString *, id> *)dictionaryPurchasableItem
    NS_SWIFT_NAME(dictionary());

- (NSString *)JSONString
    NS_SWIFT_NAME(JSONString());

- (NSString *)JSONPrettyString
    NS_SWIFT_NAME(JSONPrettyString());

@end

NS_ASSUME_NONNULL_END
