//
//  TCGBNetwork.h
//  Gamebase
//
//  Created by NHN on 2017. 1. 9..
//  © NHN Corp. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Gamebase/TCGBConstants.h>

#ifndef TCGBNETWORK_H
#define TCGBNETWORK_H

NS_ASSUME_NONNULL_BEGIN

typedef void(^NetworkChangedHandler)(NetworkStatus status);

/** The TCGBNetwork class indicates Network status.
 */
@interface TCGBNetwork : NSObject

/**---------------------------------------------------------------------------------------
 * @name Network Status
 *  ---------------------------------------------------------------------------------------
 */

/**
 @return NetworkStatus
 @see NetworkStatus
 */
+ (NetworkStatus)type
    NS_SWIFT_NAME(type());

/**
 @return Stringify to NetworkStatus
 @see NetworkStatus
 */
+ (NSString *)typeName
    NS_SWIFT_NAME(typeName());

/**
 @return `YES` if network is reachable.
 */
+ (BOOL)isConnected
    NS_SWIFT_NAME(isConnected());

@end

NS_ASSUME_NONNULL_END

#endif
