//
//  TCGBForcingMappingTicket.h
//  Gamebase
//
//  Created by NHN on 18/02/2019.
//  © NHN Corp. All rights reserved.
//

#ifndef TCGBForcingMappingTicket_h
#define TCGBForcingMappingTicket_h

#import <Foundation/Foundation.h>
#import <Gamebase/TCGBError.h>

NS_ASSUME_NONNULL_BEGIN

@interface TCGBForcingMappingTicket : NSObject


@property (nonatomic, strong, readonly) NSString* mappedUserId;

/**
 * The status of mapped user.
 * Use this value if you want to restrict addMapping according to user status.
 *
 * See https://docs.toast.com/ko/Game/Gamebase/ko/api-guide/#member-valid-code
 * In ForcingMappingTicket, mappedUserValid cannot be 'D' or 'M'.
 *
 * Y : Normal user. ('Y'es)
 * D : Withdrawn user. ('D'eleted)
 * B : 'B'anned user.
 * T : Withdrawal-suspended user. ('T'emporaryWithdrawn)
 * P : Ban-suspended user. ('P'ostpone)
 * M : 'M'issing account
 */
@property (nonatomic, strong, readonly) NSString *mappedUserValid;
@property (nonatomic, strong, readonly) NSString *idPCode;
@property (nonatomic, strong, readonly) NSString *forcingMappingKey;
@property (nonatomic, assign, readonly) long long expirationDate;
@property (nonatomic, strong, readonly) NSString *accessToken;
@property (nonatomic, strong, readonly, nullable) NSString *subCode;
@property (nonatomic, strong, readonly, nullable) NSDictionary<NSString *, id> *extraParams;

- (instancetype)init __attribute__((unavailable("init not available.")))
    NS_SWIFT_NAME(init());

+ (nullable TCGBForcingMappingTicket *)forcingMappingTicketFromError:(TCGBError *)error
    NS_SWIFT_NAME(forcingMappingTicket(fromError:));

+ (nullable instancetype)forcingMappingTicketWithJSONString:(NSString *)jsonString
    NS_SWIFT_NAME(forcingMappingTicket(jsonString:));

- (NSString *)jsonString
    NS_SWIFT_NAME(jsonString());

@end

@interface TCGBForcingMappingTicket (deprecated)
+ (nullable TCGBForcingMappingTicket *)forcingMappingTicketWithError:(TCGBError *)error DEPRECATED_MSG_ATTRIBUTE("Use forcingMappingTicketFromError: method instead.");

@end

NS_ASSUME_NONNULL_END

#endif /* TCGBForcingMappingTicket_h */
