//
//  TCGBContactConfiguration.h
//  Gamebase
//
//  Created by NHN on 2020/09/01.
//  Copyright © 2020 NHN Corp. All rights reserved.
//

#ifndef TCGBContactConfiguration_h
#define TCGBContactConfiguration_h

#import <Foundation/Foundation.h>
#import <Gamebase/TCGBValueObject.h>

NS_ASSUME_NONNULL_BEGIN

@interface TCGBContactConfiguration : NSObject <TCGBValueObject>

/**
This value represents the custom userName.
*/
@property (nonatomic, strong, nullable) NSString *userName;
@property (nonatomic, strong, nullable) NSDictionary<NSString *, NSString *> *extraData;
@property (nonatomic, strong, nullable) NSString *additionalURL;
@property (nonatomic, strong, nullable) NSDictionary<NSString *, NSString *> *additionalParameters;

+ (instancetype)contactConfigurationWithUserName:(NSString *)userName
    NS_SWIFT_NAME(contactConfiguration(userName:));

+ (instancetype)contactConfigurationWithUserName:(NSString *)userName extraData:(NSDictionary<NSString *, NSString *> *)extraData
    NS_SWIFT_NAME(contactConfiguration(userName:extraData:));

+ (instancetype)contactConfigurationWithAdditionalURL:(NSString *)additionalURL
    NS_SWIFT_NAME(contactConfiguration(additionalURL:));

+ (nullable instancetype)contactConfigurationWithJSONString:(NSString *)jsonString
    NS_SWIFT_NAME(contactConfiguration(jsonString:));

- (NSString *)jsonString
    NS_SWIFT_NAME(jsonString());

- (NSString *)prettyJsonString
    NS_SWIFT_NAME(prettyJsonString());

@end

NS_ASSUME_NONNULL_END

#endif /* TCGBContactConfiguration_h */
