﻿#pragma once

#include "CoreMinimal.h"
#include "NhnWebViewCallback.h"
#include "NhnWebViewConfiguration.h"
#include "Subsystems/GameInstanceSubsystem.h"
#include "NhnWebViewSubsystem.generated.h"

class FNhnWebViewManager;

UCLASS()
class NHNWEBVIEW_API UNhnWebViewSubsystem : public UGameInstanceSubsystem
{
    GENERATED_BODY()

public:
    void ShowWebView(const FString& Url, const FNhnWebViewConfiguration& Configuration, const FNhnWebViewEventListener& EventListener = {}) const;
    void CloseWebView() const;

protected:
    // USubsystem interface
    virtual void Initialize(FSubsystemCollectionBase& Collection) override;
    virtual void Deinitialize() override;
    // ~USubsystem interface

private:
    TSharedPtr<FNhnWebViewManager> Manager;
};