// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "NhnWebViewError.generated.h"

USTRUCT()
struct NHNWEBVIEW_API FNhnWebViewError
{
    GENERATED_BODY();

    explicit FNhnWebViewError() = default;
    explicit FNhnWebViewError(const int32 Code, const FString& Message = {});
    
    FString ToString() const;

    UPROPERTY()
    int32 Code;
    
    UPROPERTY()
    FString Message;
};

using FNhnWebViewErrorPtr = TSharedPtr<FNhnWebViewError>;
    
TSharedPtr<FNhnWebViewError> MakeError(int32 Code);
