// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "INhnCefNativeInvoker.h"
#include "NhnCefWindowsWrapper.h"

class FNhnCefWindowsInvoker final : public INhnCefNativeInvoker
{
public:
    FNhnCefWindowsInvoker();
    virtual ~FNhnCefWindowsInvoker() override;
    
    virtual bool Initialize(const FString& Locale) override;
    virtual void CreateWeb(const int32 WebIndex, const int32 X, const int32 Y, const int32 Width, const int32 Height, void* Buffer, const int32 Option) override;
    virtual void RemoveWeb(const int32 WebIndex) override;
    virtual void LoadWeb(const int32 WebIndex, const FString URL, bool bIsShowScrollbar) override;
    virtual void ResizeWeb(const int32 WebIndex, void* Buffer, const int32 Width, const int32 Height) override;
    virtual void ShowScrollbar(const int32 WebIndex, const bool bIsShow) override;
    virtual int32 UpdateWeb(const int32 WebIndex, FString& URL, int32& AdditionalInfo) override;
    virtual void ExitCef() override;
    virtual void InputWeb(const int32 WebIndex, const int32 Flags, const int32 X, const int32 Y) override;
    virtual void GoBackForwardHome(const int32 WebIndex, const int32 Direction) override;
    virtual bool CanGoBackForward(const int32 WebIndex, const int32 Direction) override;
    virtual void ExecuteJavaScript(const int32 WebIndex, const FString JavaScript) override;
    virtual void ReserveInvalidRedirectUrlSchemes(const FString Schemes) override;
    virtual void SetDownloadCompleteOption(int Option) override;
    virtual void SetDebugEnable(bool bEnable) override;
    virtual void ImeSetComposition(const int32 WebIndex, const FString Text, const int32 BeginIndex, const int32 Length) override;
    virtual void ImeCommitText(const int32 WebIndex, const FString Text) override;
    virtual void ImeFinishComposingText(const int32 WebIndex, const bool bKeepSelection) override;
    virtual void ImeCancelComposition(const int32 WebIndex) override;
    virtual int32 GetCompositionBoundIndex(const int32 WebIndex, const int32 X, const int32 Y) override;
    virtual int32 GetCompositionBoundSize(const int32 WebIndex) override;
    virtual void GetCompositionBound(const int32 WebIndex, int32 BoundIndex, int32& X, int32& Y, int32& Width, int32& Height) override;
    virtual void SetOnFocusedNodeChanged(const int32 WebIndex, const OnFocusedNodeChangedDelegate& Callback) override;
    virtual void SetOnKeyEvent(const int32 WebIndex, const OnKeyEventDelegate& Callback) override;
    virtual void SetOnImeCompositionRangeChanged(const int32 WebIndex, const OnImeCompositionRangeChangedDelegate& Callback) override;
    virtual void SetPopupIcon(const int32 WebIndex, const FString& popupIconPath) override;
private:
    void LoadMethods();
    
private:
    NhnCefWindowsWrapper::FFunctionList Functions;
};