﻿#pragma once

#include "CoreMinimal.h"
#include "Styling/NhnWebViewStyleSet.h"
#include "Widgets/SCompoundWidget.h"

DECLARE_DELEGATE_TwoParams(FWebViewDialogCloseDelegate, int32, bool);

class SNhnWebViewDialog final : public SCompoundWidget
{
public:
    SLATE_BEGIN_ARGS(SNhnWebViewDialog)
        : _StyleSet(&FNhnWebViewStyleSet::Get())
    {
    }
    SLATE_ARGUMENT(const ISlateStyle*, StyleSet)
    SLATE_ARGUMENT(int32, Index)
    SLATE_ARGUMENT(int32, JsDialogType)
    SLATE_ARGUMENT(FString, JsDialogMessage)
    SLATE_EVENT(FWebViewDialogCloseDelegate, OnCloseDialog)
    SLATE_END_ARGS()

    /** Constructs this widget with InArgs */
    void Construct(const FArguments& InArgs);

private:
    FReply OnOkButtonClicked() const;
    FReply OnCancelButtonClicked() const;
    
private:
    const ISlateStyle* StyleSet = nullptr;
    int32 Index;

    FWebViewDialogCloseDelegate OnCloseDialog;
};
