﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Widgets/SCompoundWidget.h"

class FNhnWebViewViewport;
class SViewport;

class SNhnWebViewContent final : public SCompoundWidget
{
public:
    SLATE_BEGIN_ARGS(SNhnWebViewContent)
        : _ViewportSize(FVector::ZeroVector)
        , _BackgroundColor(0, 0, 0, 122)
        {
        }
    SLATE_ARGUMENT(TSharedPtr<SWindow>, ParentWindow)
    SLATE_ATTRIBUTE(FVector2D, ViewportSize);
    SLATE_ARGUMENT(FColor, BackgroundColor)
    SLATE_END_ARGS()

    /** Constructs this widget with InArgs */
    void Construct(const FArguments& InArgs);

    FVector2D GetViewportSize() const;
    FVector2D GetPosition() const;

    void SetWebView(const int32 WebIndex, const TSharedPtr<SWidget>& ParentWidget) const;

private:
    TSharedPtr<FNhnWebViewViewport> ContentViewport;
    TSharedPtr<SViewport> ContentWidget;
};
