﻿#include "SNhnWebViewContent.h"
#include "SlateOptMacros.h"
#include "Internal/NhnWebViewViewport.h"
#include "Widgets/SViewport.h"

BEGIN_SLATE_FUNCTION_BUILD_OPTIMIZATION

void SNhnWebViewContent::Construct(const FArguments& InArgs)
{
    ContentWidget = SNew(SViewport)
        .EnableGammaCorrection(false)
        .EnableBlending(false)
        .IgnoreTextureAlpha(true)
        .ViewportSize(InArgs._ViewportSize)
        .Visibility(EVisibility::Visible);
    
    ChildSlot
    [
        ContentWidget.ToSharedRef()
    ];
    
    ContentViewport = MakeShared<FNhnWebViewViewport>();
    
    ContentWidget->SetViewportInterface(ContentViewport.ToSharedRef());
}

FVector2D SNhnWebViewContent::GetViewportSize() const
{
    return ContentWidget->ComputeDesiredSize(1.0f);
}

FVector2D SNhnWebViewContent::GetPosition() const
{
    FWidgetPath WidgetPath;
    FSlateApplication::Get().GeneratePathToWidgetUnchecked(SharedThis(this), WidgetPath);
    if (WidgetPath.IsValid())
    {
#if ENGINE_MAJOR_VERSION == 4 && ENGINE_MINOR_VERSION <= 27
        TSharedRef<SWidget> ContentRef = ContentWidget.ToSharedRef();
        const FGeometry& Geometry = WidgetPath.Widgets.Last().Geometry;

        return Geometry.AbsolutePosition;
#else
        TSharedRef<SWidget> ContentRef = ContentWidget.ToSharedRef();
        const FGeometry& Geometry = WidgetPath.Widgets.Last().Geometry;

        return UE::Math::TVector2<double>(Geometry.AbsolutePosition.X, Geometry.AbsolutePosition.Y);
#endif
    }

    return FVector2D::ZeroVector;
}

void SNhnWebViewContent::SetWebView(const int32 WebIndex, const TSharedPtr<SWidget>& ParentWidget) const
{
    ContentViewport.ToSharedRef().Get().SetWebView(WebIndex, ParentWidget);
}

END_SLATE_FUNCTION_BUILD_OPTIMIZATION
