﻿#pragma once

#include "CoreMinimal.h"
#include "Styling/NhnWebViewStyleSet.h"
#include "Widgets/SCompoundWidget.h"

class SNhnWebViewContent;

DECLARE_DELEGATE_OneParam(FWebViewCloseDelegate, int32);

class SNhnWebView final : public SCompoundWidget
{
public:
    SLATE_BEGIN_ARGS(SNhnWebView)
        : _StyleSet(&FNhnWebViewStyleSet::Get())
        , _ViewportSize(FVector2D::ZeroVector)
        , _ShowNavigationBar(true)
        , _ShowForwardButton(false)
        , _ShowAlwaysNavigationButtons(false)
        , _ShowBackButton(true)
    {
    }
    SLATE_ARGUMENT(UGameViewportClient*, GameViewport)
    SLATE_ARGUMENT(const ISlateStyle*, StyleSet)
    SLATE_ARGUMENT(int32, WebIndex)
    SLATE_ARGUMENT(FVector2D, ViewportSize)
    SLATE_ARGUMENT(bool, ShowNavigationBar)
    SLATE_ARGUMENT(bool, ShowForwardButton)
    SLATE_ARGUMENT(bool, ShowAlwaysNavigationButtons)
    SLATE_ARGUMENT(bool, ShowBackButton)
    SLATE_ARGUMENT(int32, NavigationBarHeight)
    SLATE_ARGUMENT(FColor, TitleColor)
    SLATE_ARGUMENT(FColor, NavigationBarColor)
    SLATE_ARGUMENT(FColor, NavigationBarIconTintColor)
    SLATE_ARGUMENT(FColor, BackgroundColor)
    SLATE_ARGUMENT(FColor, ContentBackgroundColor)
    SLATE_ARGUMENT(FString, Title)
    SLATE_EVENT(FWebViewCloseDelegate, OnCloseWebView)
    SLATE_END_ARGS()
    
    void Construct(const FArguments& InArgs);
    void ChangeTitle(const FString& Title) const;
    const SNhnWebViewContent& GetWebViewContent() const;
    
private:
    EVisibility IsVisibleForward() const;
    bool CanGoForward() const;
    
    EVisibility IsVisibleBack() const;
    bool CanGoBack() const;
    
    FReply OnForwardButtonClicked() const;
    FReply OnBackButtonClicked() const;
    FReply OnCloseButtonClicked() const;

private:
    TWeakObjectPtr<UGameViewportClient> GameViewport;
    
    TSharedPtr<STextBlock> TitleWidget;
    TSharedPtr<SNhnWebViewContent> WebViewContent;

    const ISlateStyle* StyleSet = nullptr;
    int32 WebIndex = -1;
    FString FixedTitle;

    bool IsShowBackButton;
    bool IsShowForwardButton;
    bool IsShowAlawaysButtons;
};
