#include "SNhnWebView.h"

#include "NhnWebViewModule.h"
#include "SlateOptMacros.h"
#include "Widgets/Images/SImage.h"
#include "NhnWebViewSubsystem.h"
#include "SNhnWebViewContent.h"

BEGIN_SLATE_FUNCTION_BUILD_OPTIMIZATION

void SNhnWebView::Construct(const FArguments& InArgs)
{
    StyleSet = InArgs._StyleSet;
    FixedTitle = InArgs._Title;
    WebIndex = InArgs._WebIndex;
    IsShowAlawaysButtons = InArgs._ShowAlwaysNavigationButtons;
    IsShowBackButton = InArgs._ShowBackButton;
    IsShowForwardButton = InArgs._ShowForwardButton;
    
    checkf(InArgs._GameViewport, TEXT("GameViewport is null."));
    GameViewport = InArgs._GameViewport;
    
    FVector2D CurrentViewportSize;
    if (InArgs._ViewportSize == FVector2D::ZeroVector)
    {
        GameViewport->GetViewportSize(CurrentViewportSize);
    }
    else
    {
        CurrentViewportSize = InArgs._ViewportSize;
    }

    const FVector2D ViewportSize(CurrentViewportSize.X, CurrentViewportSize.Y - InArgs._NavigationBarHeight);
    
    ChildSlot
        .VAlign(VAlign_Fill)
        .HAlign(HAlign_Fill)
        [
            SNew(SOverlay)
            + SOverlay::Slot()
            .HAlign(HAlign_Fill)
            .VAlign(VAlign_Fill)
            [
                SNew(SBox)
                .HAlign(HAlign_Fill)
                .VAlign(VAlign_Fill)
                [
                    SNew(SImage)
                    .Image(StyleSet->GetBrush("CefWebView.Background"))
                    .ColorAndOpacity(FLinearColor(InArgs._BackgroundColor))
                ]
            ]
            + SOverlay::Slot()
            .HAlign(HAlign_Fill)
            .VAlign(VAlign_Fill)
            [
                SNew(SBox)
                .HAlign(HAlign_Fill)
                .VAlign(VAlign_Fill)
                [
                    SNew(SButton)
                    .OnClicked(this, &SNhnWebView::OnCloseButtonClicked)
                    .ClickMethod(EButtonClickMethod::PreciseClick)
                    .ButtonColorAndOpacity(FColor::Transparent)
                    .IsFocusable(true)
                ]
            ]
            + SOverlay::Slot()
            [
                SNew(SBox)
                .VAlign(InArgs._ViewportSize.Y == 0.0f ? VAlign_Fill : VAlign_Center)
                .HAlign(InArgs._ViewportSize.Y == 0.0f ? HAlign_Fill : HAlign_Center)
                .WidthOverride(CurrentViewportSize.X)
                .HeightOverride(CurrentViewportSize.Y)
                [
                    SNew(SVerticalBox)
                    + SVerticalBox::Slot()
                    .VAlign(VAlign_Top)
                    .HAlign(HAlign_Fill)
                    .AutoHeight()
                    [
                        SNew(SOverlay)
                        .Visibility(InArgs._ShowNavigationBar ? EVisibility::Visible : EVisibility::Collapsed)
                        + SOverlay::Slot()
                        .VAlign(VAlign_Fill)
                        .HAlign(HAlign_Fill)
                        [
                            SNew(SBox)
                            .HAlign(HAlign_Fill)
                            .VAlign(VAlign_Fill)
                            .HeightOverride(InArgs._NavigationBarHeight)
                            [
                                SNew(SImage)
                                .Image(StyleSet->GetBrush("CefWebView.Navigation.Background"))
                                .ColorAndOpacity(InArgs._NavigationBarColor)
                            ]
                        ]
                        + SOverlay::Slot()
                        .VAlign(VAlign_Fill)
                        .HAlign(HAlign_Fill)
                        [
                            SNew(SHorizontalBox)
                            +SHorizontalBox::Slot()
                            .HAlign(HAlign_Left)
                            [
                                SNew(SHorizontalBox)
                                +SHorizontalBox::Slot()
                                .HAlign(HAlign_Left)
                                [
                                    SNew(SButton)
                                    .VAlign(VAlign_Fill)
                                    .Visibility(this, &SNhnWebView::IsVisibleBack)
                                    .IsEnabled(this, &SNhnWebView::CanGoBack)
                                    .OnClicked(this, &SNhnWebView::OnBackButtonClicked)
                                    .ButtonColorAndOpacity(FColor::Transparent)
                                    .ClickMethod(EButtonClickMethod::MouseDown)
                                    .IsFocusable(false)
                                    [
                                        SNew(SImage)
                                        .Image(StyleSet->GetBrush("CefWebView.BackButton.Image"))
                                        .ColorAndOpacity(InArgs._NavigationBarIconTintColor)
                                    ]
                                ]
                                +SHorizontalBox::Slot()
                                .HAlign(HAlign_Right)
                                [
                                    SNew(SButton)
                                    .VAlign(VAlign_Fill)
                                    .Visibility(this, &SNhnWebView::IsVisibleForward)
                                    .IsEnabled(this, &SNhnWebView::CanGoForward)
                                    .OnClicked(this, &SNhnWebView::OnForwardButtonClicked)
                                    .ButtonColorAndOpacity(FColor::Transparent)
                                    .ClickMethod(EButtonClickMethod::MouseDown)
                                    .IsFocusable(false)
                                    [
                                        SNew(SImage)
                                        .Image(StyleSet->GetBrush("CefWebView.BackButton.Image"))
                                        .RenderTransformPivot(FVector2D(0.5f, 0.5f))
                                        .RenderTransform(FSlateRenderTransform(FQuat2D(FMath::DegreesToRadians(180.0f))))
                                        .ColorAndOpacity(InArgs._NavigationBarIconTintColor)
                                    ]
                                ]
                            ]
                            + SHorizontalBox::Slot()
                            .HAlign(HAlign_Center)
                            .VAlign(VAlign_Center)
                            .AutoWidth()
                            [
                                SNew(SBox)
                                .HAlign(HAlign_Fill)
                                [
                                    SAssignNew(TitleWidget, STextBlock)
                                    .Text(FText::FromString(InArgs._Title))
                                    .TextStyle(StyleSet, "CefWebView.SubTitleText")
                                    .ColorAndOpacity(InArgs._TitleColor)
                                ]
                            ]
                            +SHorizontalBox::Slot()
                            .HAlign(HAlign_Right)
                            [
                                SNew(SButton)
                                .VAlign(VAlign_Fill)
                                .OnClicked(this, &SNhnWebView::OnCloseButtonClicked)
                                .ClickMethod(EButtonClickMethod::MouseDown)
                                .ButtonColorAndOpacity(FColor::Transparent)
                                .IsFocusable(false)
                                [
                                    SNew(SImage)
                                    .Image(StyleSet->GetBrush("CefWebView.CloseButton.Image"))
                                    .ColorAndOpacity(InArgs._NavigationBarIconTintColor)
                                ]
                            ]
                        ]
                    ]
                    + SVerticalBox::Slot()
                    .VAlign(VAlign_Fill)
                    .HAlign(HAlign_Fill)
                    [
                        SNew(SOverlay)
                        +SOverlay::Slot()
                        [
                            SAssignNew(WebViewContent, SNhnWebViewContent)
                            .BackgroundColor(InArgs._ContentBackgroundColor)
                            .ViewportSize(ViewportSize)
                        ]
                    ]
                ]
            ]
        ];
    
    WebViewContent.ToSharedRef().Get().SetWebView(WebIndex, SharedThis(this));
}

void SNhnWebView::ChangeTitle(const FString& Title) const
{
    if (FixedTitle.IsEmpty() == false)
    {
        return;
    }
    
    TitleWidget->SetText(FText::FromString(Title));
}

const SNhnWebViewContent& SNhnWebView::GetWebViewContent() const
{
    return *WebViewContent;
}

EVisibility SNhnWebView::IsVisibleForward() const
{
    if (!IsShowForwardButton)
    {
        return EVisibility::Collapsed;
    }
    
    if (IsShowAlawaysButtons)
    {
        return EVisibility::Visible;
    }

    return FNhnWebViewModule::Get().CanGoForward(WebIndex) ? EVisibility::Visible : EVisibility::Collapsed;
}

bool SNhnWebView::CanGoForward() const
{
    return FNhnWebViewModule::Get().CanGoForward(WebIndex);
}

EVisibility SNhnWebView::IsVisibleBack() const
{
    if (!IsShowBackButton)
    {
        return EVisibility::Collapsed;
    }
    
    if (IsShowAlawaysButtons)
    {
        return EVisibility::Visible;
    }

    return FNhnWebViewModule::Get().CanGoBack(WebIndex) ? EVisibility::Visible : EVisibility::Collapsed;
}

bool SNhnWebView::CanGoBack() const
{
    return FNhnWebViewModule::Get().CanGoBack(WebIndex);
}

FReply SNhnWebView::OnForwardButtonClicked() const
{
    FNhnWebViewModule::Get().GoForward(WebIndex, nullptr);
    
    return FReply::Handled();
}

FReply SNhnWebView::OnBackButtonClicked() const
{
    FNhnWebViewModule::Get().GoBack(WebIndex, nullptr);
    
    return FReply::Handled();
}

FReply SNhnWebView::OnCloseButtonClicked() const
{
    if (GameViewport.IsValid())
    {
        if (const UGameInstance* GameInstance = GameViewport->GetGameInstance())
        {
            if (const UNhnWebViewSubsystem* Subsystem = GameInstance->GetSubsystem<UNhnWebViewSubsystem>())
            {
                Subsystem->CloseWebView();
            }
        }
    }
    
    return FReply::Handled();
}

END_SLATE_FUNCTION_BUILD_OPTIMIZATION
