﻿#include "NhnWebViewSubsystem.h"

#include "NhnWebViewManager.h"
#include "Styling/NhnWebViewStyleSet.h"

void UNhnWebViewSubsystem::ShowWebView(const FString& Url, const FNhnWebViewConfiguration& Configuration, const FNhnWebViewEventListener& EventListener) const
{
    Manager->ShowWebView(Url, Configuration, EventListener);
}

void UNhnWebViewSubsystem::CloseWebView() const
{
    Manager->CloseWebView();
}

void UNhnWebViewSubsystem::Initialize(FSubsystemCollectionBase& Collection)
{
    Super::Initialize(Collection);

    Manager = MakeShared<FNhnWebViewManager>(this);
    
    FNhnWebViewStyleSet::Initialize();
}

void UNhnWebViewSubsystem::Deinitialize()
{
    Super::Deinitialize();
    
    if (Manager != nullptr && Manager->ExistWebView())
    {
        Manager->CloseWebView(true);
    }
    
    FNhnWebViewStyleSet::Shutdown();
}
